#ifndef f_AVIREADHANDLER_H
#define f_AVIREADHANDLER_H

#include <windows.h>
#include <vfw.h>

// These are meant as AVIFile replacements.  They're not quite to AVIFile
// specs, but they'll do for now.

class IAVIReadStream {
public:
	virtual ~IAVIReadStream();

	virtual HRESULT BeginStreaming(long lStart, long lEnd, long lRate)=0;
	virtual HRESULT EndStreaming()=0;
	virtual HRESULT Info(AVISTREAMINFO *pasi, long lSize)=0;
	virtual bool IsKeyFrame(long lFrame)=0;
	virtual HRESULT Read(long lStart, long lSamples, void *lpBuffer, long cbBuffer, long *plBytes, long *plSamples)=0;
	virtual long Start()=0;
	virtual long End()=0;
	virtual long PrevKeyFrame(long lFrame)=0;
	virtual long NextKeyFrame(long lFrame)=0;
	virtual long NearestKeyFrame(long lFrame)=0;
	virtual HRESULT FormatSize(long lFrame, long *plSize)=0;
	virtual HRESULT ReadFormat(long lFrame, void *pFormat, long *plSize)=0;
	virtual bool isStreaming()=0;
};

class IAVIReadHandler {
public:
	virtual void AddRef()=0;
	virtual void Release()=0;
	virtual IAVIReadStream *GetStream(DWORD fccType, LONG lParam)=0;
	virtual void EnableFastIO(bool)=0;
	virtual bool isOptimizedForRealtime()=0;
	virtual bool isStreaming()=0;
	virtual bool isIndexFabricated()=0;
	virtual bool AppendFile(const char *pszFile)=0;
	virtual bool getSegmentHint(const char **ppszPath)=0;
};

IAVIReadHandler *CreateAVIReadHandler(PAVIFILE paf);
IAVIReadHandler *CreateAVIReadHandler(const char *pszFile);

#endif
