#ifndef f_DUBSTATUS_H
#define f_DUBSTATUS_H

typedef void (*DubPositionCallback)(LONG start_pos, LONG cur_pos, LONG end_pos);

class DubAudioStreamInfo;
class DubVideoStreamInfo;
class AudioSource;
class VideoSource;
class InputFile;
class AudioStream;
class IDubber;
class DubOptions;

class __declspec(novtable) IDubStatusHandler {
public:
	virtual ~IDubStatusHandler() {};
	virtual void InitLinks(DubAudioStreamInfo	*painfo,
		DubVideoStreamInfo	*pvinfo,
		AudioSource			*aSrc,
		VideoSource			*vSrc,
		InputFile			*pInput,
		AudioStream			*audioStreamSource,

		IDubber				*pDubber,
		DubOptions			*opt)=0;
	virtual void NotifyNewFrame(long lSize)=0;
	virtual HWND Display(HWND hwndParent, int iInitialPriority)=0;
	virtual void Destroy()=0;
	virtual void SetPositionCallback(DubPositionCallback dpc)	=0;
	virtual bool ToggleStatus()=0;
	virtual void SetLastPosition(LONG pos)=0;
	virtual void Freeze()=0;
	virtual bool isVisible()=0;
	virtual bool isFrameVisible(bool)=0;
	virtual bool ToggleFrame(bool)=0;
};

IDubStatusHandler *CreateDubStatusHandler();

#ifndef f_DUBSTATUS_CPP
extern const char *const g_szDubPriorities[];
#endif

#endif
