#ifndef f_FASTWRITESTREAM_H
#define f_FASTWRITESTREAM_H

class FastWriteStream {
private:
	HANDLE hFile, hFileSlow, hFileClose;
	long lBufferSize;
	long lChunkSize;

	void *lpBuffer;
	long lReadPointer;
	long lWritePointer;
	volatile long lDataPoint;

	HANDLE hThread;
	HANDLE hEventOkRead, hEventOkWrite;

	volatile DWORD dwErrorRet;
	volatile BOOL fDie, fFlush;

	bool fSynchronous;

	/////////

	void _construct(bool);
	void _destruct();

	void ThrowError();

	static unsigned __stdcall BackgroundThreadStart(void *thisPtr);
	void BackgroundWrite(HANDLE, long lOffset, long lSize);
	void BackgroundThread();

public:
	FastWriteStream(const char *lpszFile, long lBufferSize, long lChunkSize, bool fLaunchThread = true);
	FastWriteStream(HANDLE hFile, long lBufferSize, long lChunkSize, bool fLaunchThread = true);
	~FastWriteStream();

	void _Put(void *data, long len);
	void Put(void *data, long len);
	void Putc(char c);
	void Putl(long l);
	long Flush1();
	void Flush2(HANDLE);
	void FlushStart();
	void Seek(__int64 llPos);

	long getBufferStatus(long *lplBufferSize);
	HANDLE getSyncHandle() {
		return hEventOkRead;
	}
	void putError(DWORD);
	bool BackgroundCheck();

	void setSynchronous(bool f) {
		fSynchronous = f;
	}
};

#endif
