#ifndef f_SCENEDETECTOR_H
#define f_SCENEDETECTOR_H

#include "VBitmap.h"

class SceneDetector {
private:
	Pixel *cur_lummap, *last_lummap;
	long tile_w, tile_h;
	BOOL last_valid;
	BOOL first_diff;
	BOOL last_fade_state;

	long cut_threshold;
	double fade_threshold;

	_destruct();

	void BitmapToLummap(Pixel *lummap, VBitmap *vbm);
	void FlipBuffers();

public:
	SceneDetector(PixDim width, PixDim height);
	~SceneDetector();

	void SetThresholds(int cut_threshold, int fade_threshold);
	BOOL Submit(VBitmap *vbm);
	void Reset();
};

#endif
