#ifndef f_VIDEOSEQUENCECOMPRESSOR_H
#define f_VIDEOSEQUENCECOMPRESSOR_H

#include <windows.h>
#include <vfw.h>

class VideoSequenceCompressor {
public:
	VideoSequenceCompressor();
	~VideoSequenceCompressor();

	void init(HIC hic, BITMAPINFO *pbiInput, BITMAPINFO *pbiOutput, long lQ, long lKeyRate);
	void setDataRate(long lDataRate, long lUsPerFrame, long lFrameCount);
	void start();
	void dropFrame();
	void *packFrame(void *pBits, bool *pfKeyframe, long *plSize);
	void finish();

	bool isSequenceIntelligent() {
		return !!(dwFlags & VIDCF_COMPRESSFRAMES);
	}

	long getMaxSize() {
		return lMaxPackedSize;
	}

private:
	HIC			hic;
	DWORD		dwFlags;
	BITMAPINFO	*pbiInput, *pbiOutput;
	char		*pOutputBuffer, *pPrevBuffer;
	long		lFrameNum, lKeyRate, lQuality;
	long		lKeyRateCounter;
	long		lMaxFrameSize;
	long		lMaxPackedSize;
	bool		fCompressionStarted;
	long		lSlopSpace;

	void		*pConfigData;
	int			cbConfigData;
};

#endif
