/*
	Lightbox JS: Fullsize Image Overlays
	by Lokesh Dhakar - http://www.huddletogether.com

	For more information on this script, visit:
	http://huddletogether.com/projects/lightbox/

	Licensed under the Creative Commons Attribution 2.5 License - http://creativecommons.org/licenses/by/2.5/
	(basically, do anything you want, just leave my name and link)

	edited by Alexander Oelzant-Faderler aoe@30hd.org to remove gif dependencies and extend keyboard functions (esc/left/right)

	only lightbox[] seems to work - not without brackets?

	Table of Contents
	-----------------
	Configuration

	Functions
	- getPageScroll()
	- getPageSize()
	- pause()
	- getKey()
	- listenKey()
	- showLightbox()
	- hideLightbox()
	- initLightbox()
	- addLoadEvent()

	Function Calls
	- addLoadEvent(initLightbox)

*/
/*
  Edited by Ender (c) 2006-11-07
  Public Domain

  Supports gallery browsing, next/prev image, expects allimages to be an array of pairs array(filename,title)
  If allimages does not exist, or the currently opened image is not found there, no browsing is shown,
  acts as normal lightbox.

  Also altered so that the navi bar below the image is always shown, even if we
  have to scroll down a bit - maybe not really portable, but IE6&FF1.5 are ok

  Also added cancelling of loading current image - when we start a different one (user
  is clicking next next next before it loads and does not really want a slideshow)

  And finally when user clicks on progressbar/the shaded page, he does not want it to
  disappear and then get surprised by an image popping out of nowhere, so even
  here we cancel loading
*/


//
// Configuration
//

// If you would like to use a custom loading image or close button reference them in the next two lines.
var loadingImage = 'https://www.ddr.cz/graphics/loading.gif';
// var loadingImage = 'about:blank';
var closeButton = 'https://www.ddr.cz/graphics/close.gif';





//
// getPageScroll()
// Returns array with x,y page scroll values.
// Core code from - quirksmode.org
//
function getPageScroll(){

	var yScroll;

	if (self.pageYOffset) {
		yScroll = self.pageYOffset;
	} else if (document.documentElement && document.documentElement.scrollTop){	 // Explorer 6 Strict
		yScroll = document.documentElement.scrollTop;
	} else if (document.body) {// all other Explorers
		yScroll = document.body.scrollTop;
	}

	arrayPageScroll = new Array('',yScroll)
	return arrayPageScroll;
}



//
// getPageSize()
// Returns array with page width, height and window width, height
// Core code from - quirksmode.org
// Edit for Firefox by pHaez
//
function getPageSize(){

	var xScroll, yScroll;

	if (window.innerHeight && window.scrollMaxY) {
		xScroll = document.body.scrollWidth;
		yScroll = window.innerHeight + window.scrollMaxY;
	} else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
		xScroll = document.body.scrollWidth;
		yScroll = document.body.scrollHeight;
	} else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
		xScroll = document.body.offsetWidth;
		yScroll = document.body.offsetHeight;
	}

	var windowWidth, windowHeight;
	if (self.innerHeight) {	// all except Explorer
		windowWidth = self.innerWidth;
		windowHeight = self.innerHeight;
	} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
		windowWidth = document.documentElement.clientWidth;
		windowHeight = document.documentElement.clientHeight;
	} else if (document.body) { // other Explorers
		windowWidth = document.body.clientWidth;
		windowHeight = document.body.clientHeight;
	}

	// for small pages with total height less then height of the viewport
	if(yScroll < windowHeight){
		pageHeight = windowHeight;
	} else {
		pageHeight = yScroll;
	}

	// for small pages with total width less then width of the viewport
	if(xScroll < windowWidth){
		pageWidth = windowWidth;
	} else {
		pageWidth = xScroll;
	}


	arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight)
	return arrayPageSize;
}


//
// pause(numberMillis)
// Pauses code execution for specified time. Uses busy code, not good.
// Code from http://www.faqts.com/knowledge_base/view.phtml/aid/1602
//
function pause(numberMillis) {
	var now = new Date();
	var exitTime = now.getTime() + numberMillis;
	while (true) {
		now = new Date();
		if (now.getTime() > exitTime)
			return;
	}
}

//
// getKey(key)
// Gets keycode. If 'x' is pressed then it hides the lightbox.
//

function getKey(e){
	var prevhref=null; thishref=null; nexthref=null;
	if (e == null) { // ie
		keycode = event.keyCode;
	} else { // mozilla
		keycode = e.which;
	}
	// key = String.fromCharCode(keycode).toLowerCase();
	// if(key == 'x'){ hideLightbox(); }
	console.log("key: " + e.key);
	if (e.key == 'ArrowRight' || e.key == 'ArrowLeft' ) {
	var li;
			lie=document.getElementById("lightboxImage");
				li=lie.getAttribute("src");
	console.log("li: " + li);
				
    	var anchors = document.getElementsByTagName("a");
			var thisrel;
			var prevhref=null; thishref=null; nexthref=null;
			var firsthref=null; lasthref=null;
	    for(i = 0; i < anchors.length; i++) {
					if (anchors[i].getAttribute('rel')) {
						h=anchors[i].getAttribute('href');
						m=h;
						if (n=h.match(/[^\/]+$/))
							m=n[0];
						if(li.match(m)) {
							thisrel=anchors[i].getAttribute('rel');
							break;
						}
					}
			}
	console.log("rel: " + thisrel);
	if (!thisrel)
		thisrel="lightbox[]"
			for(i = 0; i < anchors.length; i++) {
	        if(anchors[i].id == 'lightboxImageNext' || anchors[i].id == 'lightboxImagePrev')
	            continue;
	        if(anchors[i].getAttribute('rel') == thisrel) {
						h=anchors[i].getAttribute('href');
	// console.log("h: " + h);
						if (firsthref == null)
							firsthref=anchors[i];
						pat=anchors[i].getAttribute('href').replace(/\?/,".");
						
						if (li.match(pat))  {
							thishref = li;
							// console.log("found this href " + anchors[i].getAttribute('href'));
						}
						if(thishref == null) {
							prevhref=anchors[i];
							// console.log("set prev");
						}
							if (!li.match(pat) && thishref != null && nexthref == null) {
								// console.log("set next href");
								nexthref=anchors[i];
							}
						lasthref=anchors[i];
					}
	    }
			if (prevhref==null)
				prevhref=lasthref;
			if (nexthref==null)
				nexthref=firsthref;
			// console.log("prev: " + prevhref.href);
			// console.log("next: " + nexthref.href);
	}
	// console.log("key: " + e.key);
	switch (e.key) {
		case 'Esc':
		case 'Escape':
		case 'x':
			hideLightbox();
			break;
		case 'ArrowLeft':
		 if (prevhref != null) {
				// hideLightbox();
				showLightbox(prevhref);
			}
			break;
		case 'ArrowRight':
			if (nexthref != null) { 
				// hideLightbox();
				showLightbox(nexthref);
				}
			break;
	}
}


//
// listenKey()
//
// function listenKey () {	document.onkeypress = getKey; }
function listenKey () {	
document.onkeydown = getKey; 

}


//
// showLightbox()
// Preloads images. Pleaces new image in lightbox then centers and displays.
//
var imgPreload;
	var infadetimeout;
	var fadeinwait;
function showLightbox(objLink)
{
	// prep objects
	var objOverlay = document.getElementById('overlay');
	var objLightbox = document.getElementById('lightbox');
	var objCaption = document.getElementById('lightboxCaption');
	var objImage = document.getElementById('lightboxImage');
	var objLoadingImage = document.getElementById('loadingImage');
	var objLightboxDetails = document.getElementById('lightboxDetails');
	var objImageName = document.getElementById('lightboxImageName');
	var objImageDetails = document.getElementById('lightboxImageDetails');
	var objImageNum = document.getElementById('lightboxImageNum');
	var objImageCount = document.getElementById('lightboxImageCount');
	var objImageNext = document.getElementById('lightboxImageNext');
	var objImagePrev = document.getElementById('lightboxImagePrev');
	var objLoadingImageAnchor = document.getElementById('loadingImageAnchor');
	var first=null, last=null;
	
	linkhref = objLink.href;
	tag=linkhref.replace(/.*\//,"");
	if (tag && tag != "")
		document.location.hash="#"+tag;
	
	if(objLightbox.style.display == 'block' && (!objLightbox.fading || infadetimeout)) {
	    if(infadetimeout) clearTimeout(infadetimeout);

	    var fadeout=function() {
	        if(fadeopacity > 0) {
	            fadeopacity -= 0.08;
	            if(fadeopacity < 0) fadeopacity = 0;
	            
	            objImage.style.opacity = fadeopacity;
	            objImage.style.filter = "Alpha(Opacity=" + (fadeopacity*100) + ")";
	            
	            setTimeout(fadeout, 50);
	        }
	        else {
              objImage.style.visibility = 'hidden';
	            objImage.style.opacity = "";
        	    objImage.style.filter = "Alpha(Opacity=1)";
	            objLightbox.fading = false;
	        }
	    }
	    var fadeopacity = (objImage.style.opacity > 0 ? objImage.style.opacity : 1);
	    objLightbox.fading = true;
	    setTimeout(fadeout, 50);
	}
	else {
        objImage.style.visibility = 'hidden';
  }

	objLoadingImageAnchor.style.display = '';
	if(lbRE.exec(objLink.getAttribute('rel'))) {
	    objImageName.style.visibility = 'visible';
	    objImageDetails.style.visibility = 'visible';

    	var anchors = document.getElementsByTagName("a");
			first=null;
	    for(i = 0, num1 = 0; i < anchors.length; i++) {
	        if(anchors[i].id == 'lightboxImageNext' || anchors[i].id == 'lightboxImagePrev')
	            continue;
	            
	        if(anchors[i].getAttribute('rel') == objLink.getAttribute('rel')) {
							if (first == null)
								first=i;
							last=i;
	            num1++;
					}

	        //if(anchors[i].href == objLink.href)
	        if(anchors[i].href == objLink.href && anchors[i].getAttribute('rel') == objLink.getAttribute('rel')) {
						num=num1;
						i1=i;
					}
	    }
			i=i1;

	    for(prev = i - 1; prev >= -1; prev--) {
				if (prev >= 0) {
	        if(anchors[prev].id == 'lightboxImageNext' || anchors[prev].id == 'lightboxImagePrev')
	            continue;
	            
	        if(anchors[prev].getAttribute('rel') == objLink.getAttribute('rel'))
	            break;
				}
	    }

	    for(next = i + 1; next < anchors.length; next++) {
	        if(anchors[next].id == 'lightboxImageNext' || anchors[next].id == 'lightboxImagePrev')
	            continue;
	            
	        if(anchors[next].getAttribute('rel') == objLink.getAttribute('rel'))
	            break;
	    }
	            
      var linkimg = objLink.getElementsByTagName('img')[0];
      var title = objLink.title;
      if(!title && linkimg) title = linkimg.title;
      if(!title && linkimg) title = linkimg.alt;
      	        
      objImageName.innerHTML = title;
      objImageNum.innerHTML = num;
      objImageCount.innerHTML = lbCounts[RegExp.$1];
      objImagePrev.href = anchors[(prev >= 0 ? prev : last)].href;
      objImageNext.href = anchors[(next < anchors.length ? next : first)].href;
      objImagePrev.title = anchors[(prev>=0?prev:last)].title;
      objImageNext.title = anchors[(next < anchors.length?next:first)].title;
      objImageNext.setAttribute('rel', objLink.getAttribute('rel'));
      objImagePrev.setAttribute('rel', objLink.getAttribute('rel'));

	    objImageName.style.visibility = 'visible';
	    objImageDetails.style.visibility = 'visible';
	}
	else {
	    objImageName.style.visibility = 'hidden';
	    objImageDetails.style.visibility = 'hidden';
	}
	    

	var arrayPageSize = getPageSize();
	var arrayPageScroll = getPageScroll();
	console.log ("Pageheight: " + arrayPageSize[1] + ", Windowheight: ",arrayPageSize[3] + ", vscroll: " + arrayPageScroll[1]);

	// center loadingImage if it exists
	if (objLoadingImage) {
		objLoadingImage.style.top = (arrayPageScroll[1] + ((arrayPageSize[3] - 35 - objLoadingImage.height) / 2) + 'px');
		objLoadingImage.style.left = (((arrayPageSize[0] - 20 - objLoadingImage.width) / 2) + 'px');
		objLoadingImage.style.display = 'block';
	}

	// set height of Overlay to take up whole page and show
	objOverlay.style.height = (arrayPageSize[1] + 'px');
	objOverlay.style.display = 'block';
	objOverlay.style.opacity= '0.8';
	objOverlay.style.backgroundColor= 'black';


	if(typeof(imgPreload) != "undefined") {
	    imgPreload.onload=function(){};
	    imgPreload.src='about:blank';
	    delete imgPreload;
	    try { clearTimeout(fadeinwait); } catch(e) {};
	}
	
	// preload image
	if(imgPreload) {
	    imgPreload.onload = null;
	    delete imgPreload;
	}
	
	imgPreload = new Image();

	imgPreload.onload=function(){
	
	if(objLightbox.style.display == 'block' && objLightbox.fading) {
	    fadeinwait = setTimeout(imgPreload.onload, 100);
	    return;
	}
	
	   	objImage.src = imgPreload.src;
	    objImage.style.opacity = 0;
	    objImage.style.filter = "Alpha(Opacity=1)";
	    objImage.style.visibility = 'visible';
		// if(objImage.height > 540) objImage.height = 540;
		// aoe
		var lightboxLeft = ((arrayPageSize[0] - 20 - imgPreload.width) / 2);
		// modelrepublic align with layout:
		//offsetv=170;
		offsetv=getComputedStyle(document.getElementById('lightboxoffset')).top;
		offsetv=(offsetv.replace(/px/,""));
		offsetv=offsetv*1;
		console.log("offsetv: "+(offsetv+0));
		pich=arrayPageSize[3]-offsetv-(objLink.getAttribute('title')?30:0);
		picw=arrayPageSize[0]-20;
		displayar=picw/pich;
		imgar=imgPreload.width/imgPreload.height;
		if (displayar > imgar) {
			objImage.width=imgPreload.width*pich/imgPreload.height;
			objImage.height = pich;
			lightboxLeft = ((picw - objImage.width) / 2);
		} else {
			objImage.height = imgPreload.height*picw/imgPreload.width;
			objImage.width=picw-20;
			lightboxLeft = 0;
		}
			console.log("height "+objImage.height);
		if(objImage.height >= pich) {
			objImage.width=objImage.width*objImage.height/pich;
			objImage.height=pich;
		}
		
/*		if(imgPreload.height > arrayPageSize[3]) {
			lightboxLeft = ((arrayPageSize[0] - 20 - (arrayPageSize[3]/imgPreload.height)*imgPreload.width) / 2);
			objImage.height = arrayPageSize[3]-30;
			if (objLink.getAttribute('title'))
				objImage.height -= 30;
			console.log("lightbox: objImage.height = " + objImage.height + ", imgPreload.width = " + imgPreload.width);
		}
		if(imgPreload.width > (arrayPageSize[3]-20)) {
			objImage.width = arrayPageSize[0]-20;
		}
*/

		// center lightbox and make sure that the top and left values are not negative
		// and the image placed outside the viewport
		var lightboxTop = arrayPageScroll[1] + ((arrayPageSize[3] - 45 - imgPreload.height) / 2);
		
		if(imgPreload.height > arrayPageSize[3] - 45)
		    lightboxTop = arrayPageScroll[1] + (arrayPageSize[3] - 45 - imgPreload.height);
		
		lightboxTop = offsetv + arrayPageScroll[1];
		// aoe: avoid scroll
		// if(lightboxTop < 0) window.scrollBy(0, -lightboxTop);

		console.log("offsetv: "+offsetv + ", lightboxTop: "+lightboxTop);
		if (lightboxTop > (arrayPageSize[1]-objImage.height))
			lightboxTop=arrayPageSize[1]-objImage.height;
		objLightbox.style.top = (lightboxTop < 0) ? "0px" : lightboxTop + "px";

		objLightbox.style.width = arrayPageSize[0];
		objLightbox.style.left = "0px";
		if (title) {
			objImageName.style.height= "60px";
			objImageName.style.width = picw + "px";
			objImageName.style.position= "relative";
			objImageName.style.left= "0px";
			objImageName.style.textAlign = "center";
			// objImageName.style.background= "#000000";
		}
		// objImage.style.width = (arrayPageSize[0] - (lightboxLeft > 0?lightboxLeft:0)) + "px";
		objImage.style.position = "absolute";
		objImage.style.position = "absolute";
		objImage.style.left = (lightboxLeft < 0) ? "0px" : lightboxLeft/2 + "px";
		// aoe: enable for global hideLightbox click TODO
		objImage.onclick = function () {hideLightbox(); return false;}
		// objOverlay.onclick = function () {hideLightbox(); return false;}


		// objLightboxDetails.style.width = imgPreload.width + 'px';
		// aoe: Lightbox in full page width
		objLightboxDetails.style.width = picw + "px";;
		objLightboxDetails.style.position= "absolute";
		objLightboxDetails.style.top=pich-50 ;

		if(objImageName.style.visibility == 'hidden') {
			imgcaption = false;
			objLinkImage = objLink.getElementsByTagName('img')[0];
			if(objLink.getAttribute('title')) imgcaption = objLink.getAttribute('title');
			else if(objLinkImage && objLinkImage.getAttribute('title')) imgcaption = objLinkImage.getAttribute('title');
			else if(objLinkImage && objLinkImage.getAttribute('alt')) imgcaption = objLinkImage.getAttribute('alt');
			if(imgcaption){
				objImageName.style.visibility = 'visible';
				objImageName.innerHTML = imgcaption;
			};
			console.log("foo");
		}
		

		// A small pause between the image loading and displaying is required with IE,
		// this prevents the previous image displaying for a short burst causing flicker.

		if (navigator.appVersion.indexOf("MSIE")!=-1){
			pause(50);
		}

		if (objLoadingImage) {	objLoadingImage.style.display = 'none'; }

		// Hide select boxes as they will 'peek' through the image in IE
		selects = document.getElementsByTagName("select");
        for (i = 0; i != selects.length; i++) {
                selects[i].style.visibility = "hidden";
        }


		objLightbox.style.display = 'block';

		// After image is loaded, update the overlay height as the new image might have
		// increased the overall page height.
		arrayPageSize = getPageSize();
		// console.log ("Pageheight: " + arrayPageSize[1] + ", Windowheight: ",arrayPageSize[3]);
		// objOverlay.style.height = (arrayPageSize[1] + 'px');

		// Check for 'x' keypress
		listenKey();

	    var infade = function()
	    {
	        if(infadeopacity < 1) {
    	        infadeopacity+=0.08;
	            if(infadeopacity>1) infadeopacity = 1;
	            
        	    objImage.style.opacity = infadeopacity;
	            objImage.style.filter = "Alpha(Opacity=" + (infadeopacity*100) + ")";

        	    infadetimeout = setTimeout(infade, 50);
	        }
	        else {
        	    objImage.style.opacity = "";
        	    objImage.style.filter = "Alpha(Opacity=100)";
        	    objImage.style.visibility = 'visible';
       	    objLightbox.fading = false;
       	    infadetimeout = null;
	        }
	    }
	    var infadeopacity = 0;
 	    objLightbox.fading = true;
	    infadetimeout = setTimeout(infade, 50);


		return false;
	}

	imgPreload.src = linkhref;


}





//
// hideLightbox()
//
function hideLightbox()
{
	// get objects
	var objLoadingImageAnchor = document.getElementById('loadingImageAnchor');
	objOverlay = document.getElementById('overlay');
	objLightbox = document.getElementById('lightbox');

	// hide lightbox and overlay
	objLoadingImageAnchor.style.display = 'none';
	objOverlay.style.display = 'none';
	objLightbox.style.display = 'none';

	// stop loading current image, the user does not want it
	if(typeof(imgPreload) != "undefined") {
	    imgPreload.onload=function(){};
	    imgPreload.src='about:blank';
	    delete imgPreload;
	}

	// make select boxes visible
	selects = document.getElementsByTagName("select");
    for (i = 0; i != selects.length; i++) {
		selects[i].style.visibility = "visible";
	}

	// disable keypress listener
	// document.onkeypress = '';
	document.onkeydown= '';
}




//
// initLightbox()
// Function runs on window load, going through link tags looking for rel="lightbox".
// These links receive onclick events that enable the lightbox display for their targets.
// The function also inserts html markup at the top of the page which will be used as a
// container for the overlay pattern and the inline image.
//
var lbCounts = new Array(), lbRE = /^.*\[(.*)\]$/;
function initLightbox()
{

	if (!document.getElementsByTagName){ return; }
	var anchors = document.getElementsByTagName("a");

	// loop through all anchor tags
	for (var i=0; i<anchors.length; i++){
		var anchor = anchors[i];

		var rel = anchor.getAttribute("rel");
		if(!rel) rel = '';
		
		if (anchor.getAttribute("href") && (rel.substr(0, 8) == "lightbox")){
			anchor.onclick = function () {showLightbox(this); return false;}
			if(lbRE.exec(rel)) {
			    if(lbCounts[RegExp.$1]) lbCounts[RegExp.$1]++;
			    else lbCounts[RegExp.$1] = 1;
			}
		}
	}

	// the rest of this code inserts html at the top of the page that looks like this:
	//
	// <div id="overlay">
	//		<a href="#" onclick="hideLightbox(); return false;"><img id="loadingImage" /></a>
	//	</div>
	// <div id="lightbox">
	//		<a href="#" onclick="hideLightbox(); return false;" title="Click anywhere to close image">
	//			<img id="closeButton" />
	//			<img id="lightboxImage" />
	//		</a>
	//		<div id="lightboxDetails">
	//			<div id="lightboxCaption"></div>
	//			<div id="keyboardMsg"></div>
	//		</div>
	// </div>

	var objBody = document.getElementsByTagName("body").item(0);

	// for voffset etc.
	var objOffset = document.createElement("div");
	objOffset.setAttribute('id','lightboxoffset');
	objOffset.style.display = 'none';
	objOffset.style.position = 'absolute';
	objOffset.style.height= '0';
	objOffset.style.width= '0';
	objBody.insertBefore(objOffset, objBody.firstChild);


	// create overlay div and hardcode some functional styles (aesthetic styles are in CSS file)
	var objOverlay = document.createElement("div");
	objOverlay.setAttribute('id','overlay');
	objOverlay.onclick = function () {hideLightbox(); return false;}
	objOverlay.style.display = 'none';
	objOverlay.style.position = 'absolute';
	objOverlay.style.top = '0';
	objOverlay.style.left = '0';
	objOverlay.style.zIndex = '90';
 	objOverlay.style.width = '100%';
	objBody.insertBefore(objOverlay, objBody.firstChild);

	var arrayPageSize = getPageSize();
	var arrayPageScroll = getPageScroll();

	// preload and create loader image
	var imgPreloader = new Image();

	// if loader image found, create link to hide lightbox and create loadingimage
	imgPreloader.onload=function(){

		var objLoadingImageLink = document.createElement("a");
		objLoadingImageLink.setAttribute('id','loadingImageAnchor');
		objLoadingImageLink.setAttribute('href','#');
		objLoadingImageLink.onclick = function () {hideLightbox(); return false;}
		objBody.insertBefore(objLoadingImageLink, objBody.firstChild);

		var objLoadingImage = document.createElement("img");
//		objLoadingImage.src = loadingImage;
		objLoadingImage.setAttribute('id','loadingImage');
		objLoadingImage.style.position = 'absolute';
		objLoadingImage.style.zIndex = '150';
		objLoadingImage.style.display = 'none';
		objLoadingImageLink.appendChild(objLoadingImage);

		imgPreloader.onload=function(){};	//	clear onLoad, as IE will flip out w/animated gifs

		return false;
	}

	imgPreloader.src = loadingImage;

	// create lightbox div, same note about styles as above
	var objLightbox = document.createElement("div");
	objLightbox.setAttribute('id','lightbox');
	objLightbox.style.display = 'none';
	objLightbox.style.position = 'absolute';
	objLightbox.style.zIndex = '100';
	objBody.insertBefore(objLightbox, objOverlay.nextSibling);

	// create close link
	/*
	var objLink = document.createElement("a");
	objLink.setAttribute('href','#');
	objLink.setAttribute('title','Click to close');
	objLink.style.width='0px';
	objLink.style.display='block';
	objLink.onclick = function () {hideLightbox(); return false;}
	objLightbox.appendChild(objLink);
	*/

	// preload and create close button image
//	var imgPreloadCloseButton = new Image();
		var imgPreloadCloseButton = document.createElement("div");
		imgPreloadCloseButton.appendChild(document.createTextNode("x"));

	// if close button image found,
	imgPreloadCloseButton.onload=function(){

//		var objCloseButton = document.createElement("img");
//		objCloseButton.src = closeButton;
		var objCloseButton = document.createElement("div");
		objCloseButton.appendChild(document.createTextNode("x"));
		objCloseButton.setAttribute('id','closeButton');
		// objCloseButton.style.position = 'absolute';
		objCloseButton.style.position = 'relative';
		objCloseButton.style.zIndex = '200';
		// objLink.appendChild(objCloseButton);
	// objCloseButton.insertBefore(objLightbox.childNodes[0]);

		return false;
	}

//	imgPreloadCloseButton.src = closeButton;
		imgPreloadCloseButton.appendChild(document.createTextNode("x"));

	// create image
	var objImage = document.createElement("img");
	objImage.setAttribute('id','lightboxImage');
	//objImage.oncontextmenu = function () {return false;}
	objLightbox.appendChild(objImage);

	// create details div, a container for the caption and keyboard message
	var objLightboxDetails = document.createElement("div");
	objLightboxDetails.setAttribute('id','lightboxDetails');
	objLightbox.appendChild(objLightboxDetails);

	// create caption
	var objCaption = document.createElement("div");
	objCaption.setAttribute('id','lightboxCaption');
	objCaption.style.display = 'none';
	objLightboxDetails.appendChild(objCaption);

	// create keyboard message
	var objKeyboardMsg = document.createElement("div");
	objKeyboardMsg.setAttribute('id','keyboardMsg');
	objKeyboardMsg.style.width="100%";
	objKeyboardMsg.innerHTML = '<div id="lightboxImageName"></div>' + 
	    '<div id="lightboxImageDetails"><a href="#" rel="lightboxInternal" id="lightboxImagePrev" onclick="if(this.href.search(/#$/) == -1) showLightbox(this); return false;">&lt;</a> ' + 
	    '<span id="lightboxImageNum">†</span> / ' + 
	    '<span id="lightboxImageCount">†</span> ' + 
	    '<a href="#" rel="lightboxInternal" id="lightboxImageNext" onclick="if(this.href.search(/#$/) == -1) showLightbox(this); return false;">&gt;</a>';
	objLightboxDetails.appendChild(objKeyboardMsg);
	if (lightboxImageDetails = document.getElementById('lightboxImageDetails')) {
		lightboxImageDetails.style.position = "absolute";
		lightboxImageDetails.onclick = function () { return false;}
	}
	if (lightboxImagePrev = document.getElementById('lightboxImagePrev')) {
		lightboxImagePrev.style.textDecoration = "none"; 
	}
	if (lightboxImageNext = document.getElementById('lightboxImageNext')) {
		lightboxImageNext.style.textDecoration = "none"; 
	}
    var touchsurface = document.getElementById('overlay'),
        touchsurface1 = document.getElementById('lightboxImage'),
        startX,
        startY,
        dist,
        threshold = 80, //required min distance traveled to be considered swipe
        allowedTime = 300, // maximum time allowed to travel that distance
        elapsedTime,
        startTime

    function handleswipe(isswipe){
            // h=document.getElementById('lightboxImagePrev').innerHTML;
				var l=null;
        if (isswipe == 1) {
            // document.getElementById('lightboxImagePrev').innerHTML=h+"&gt;";
            l=document.getElementById('lightboxImagePrev');
				} else if (isswipe == -1) {
            // document.getElementById('lightboxImagePrev').innerHTML=h+"&lt;";
            l=document.getElementById('lightboxImageNext');
				} else 
					console.log("no swipe");
				if (l != null && l.href && ! l.href.match(/#$/) && l.href != "" )
					showLightbox(l);
				else
					hideLightbox();
    }

    function mytouchstart (e){
        touchsurface.innerHTML = ''
        var touchobj = e.changedTouches[0]
        dist = 0
        startX = touchobj.pageX
        startY = touchobj.pageY
        startTime = new Date().getTime() // record time when finger first makes contact with surface
        // e.preventDefault()
    }
    touchsurface.addEventListener('touchstart', mytouchstart, false)
    touchsurface1.addEventListener('touchstart', mytouchstart, false)

    function mytouchmove (e){
        e.preventDefault() // prevent scrolling when inside DIV
    }
    // touchsurface.addEventListener('touchmove', mytouchmove, false);
	
    function mytouchend (e){
        var touchobj = e.changedTouches[0]
				var multitouch=e.changedTouches.length;
				if (multitouch > 1)
					return;
        distx = touchobj.pageX - startX // get total dist traveled by finger while in contact with surface
        disty = touchobj.pageY - startY // get total dist traveled by finger while in contact with surface
				// disttot = Math.sqrt (distx*distx+disty+disty);
        elapsedTime = new Date().getTime() - startTime // get time elapsed
        // check that elapsed time is within specified, horizontal dist traveled >= threshold, and vertical dist traveled <= dist
        if (elapsedTime <= allowedTime && distx >= threshold && Math.abs(disty) < Math.abs(distx)) {
					handleswipe(1)
					e.preventDefault()
				} else if (elapsedTime <= allowedTime && distx <= -threshold && Math.abs(disty) < Math.abs(distx) ) {
					handleswipe(-1)
					e.preventDefault()
				} else if (Math.sqrt (distx*distx+disty+disty) < (5)) {
					handleswipe(0)
					e.preventDefault()
				}
    }
    touchsurface.addEventListener('touchend', mytouchend, false);
    touchsurface1.addEventListener('touchend', mytouchend, false);
}



//
// addLoadEvent()
// Adds event to window.onload without overwriting currently assigned onload functions.
// Function found at Simon Willison's weblog - http://simon.incutio.com/
//
function addLoadEvent(func)
{
	var oldonload = window.onload;
	if (typeof window.onload != 'function'){
    	window.onload = func;
	} else {
		window.onload = function(){
		oldonload();
		func();
		}
	}

}



addLoadEvent(initLightbox);	
