/* simple wrapper around programs
 * compiles fine on aix 4.3
 * cc -Wall -o readwrap readwrap.c -lreadline
 * (c) 2005 Alexander Oelzant (aoe) <alexander@oelzant.priv.at>
 *
 * $CVSHeader: readwrap/readwrap.c,v 1.10 2005/08/09 13:39:31 aoe Exp $
 */

#define VERSION "$Revision: 1.10 $"

#include <sys/types.h>
#include <signal.h>
/* wait/waitpid */
#include <sys/wait.h>
#include <stdint.h>
/* malloc */
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <readline/readline.h>
#include <readline/history.h>
/* exit, getopt */
#include <unistd.h>
/* select */
#include <sys/select.h>
/* fcntl */
#include <fcntl.h>
/* kill, signal */
#include <signal.h>
/* errno */
#include <errno.h>



#define usleep(x) {struct timeval tv;tv.tv_sec=x/1000000;tv.tv_usec=x%1000000;select(0,NULL,NULL,NULL,&tv);};

#define PROMPTSUFFIX "> "
#define DEFAULT_USLEEP 1000


/* getopt */
extern char *optarg;
extern int optind, opterr, optopt;

void usage(char *argv0) {
	printf("readwrap " VERSION " (c) 2005 aoe <alexander@oelzant.priv.at>\n\n"
"%s [options] program [progargs]\n"
"-d		debug\n"
"-e		buffer program standard error\n"
"-f		buffer program standard output\n"
"-h|-?		this help\n"
"-p prompt	set prompt\n"
"-u		set usleep time for buffer kludges (default %i)\n"
"\n",
argv0, DEFAULT_USLEEP);
}
 
int main(int argc, char **argv) {
	uint8_t *currentline, *currentpointer;
	int fdin[2];
	int fdout[2];
	int fderr[2];
	pid_t kid;
	char *prompt=NULL;
  HIST_ENTRY *prevh;
	int c; /* getopt */
	int buf_out=0, buf_err=0; 
	int debug=0;
	char **argv_new;
	char buf[1000];
	int bytes_read;
	unsigned int usleep_value=DEFAULT_USLEEP;

	argv_new=malloc(sizeof(argv[0])*(argc+1));

	while (1) {
		/* int this_option_optind = optind ? optind : 1;
		int option_index = 0; */
		c = getopt (argc, argv, "p:feh?du:");
		if (c == -1)
			break;
		switch (c) {
			case 'h':
			case '?':
				usage(argv[0]);
				exit(0);
				break;
			case 'p': /* prompt */
				prompt=optarg;
				if (debug) fprintf(stderr,"setting prompt to %s\n",prompt);
				break;
			case 'd':
				debug=1;
				fprintf(stderr,"setting debug to on\n");
				break;
			case 'f':
				buf_out=1;
				if (debug) fprintf(stderr,"setting stdout buffering to on\n");
				break;
			case 'u':
				usleep_value=atoi(optarg);
				if (debug) fprintf(stderr,"setting usleep to %i\n",usleep_value);
				break;
			case 'e':
				buf_err=1;
				if (debug) fprintf(stderr,"setting stderr buffering to on\n");
				break;
			default:
			case 0:
				printf ("option %c unknown\n",c);
				usage(argv[0]);
				exit(1);
				break;
		}
	}

	if ((argc - optind) < 1) {
		fprintf(stderr,"error: %s needs at least one argument\n", argv[0]);
		usage(argv[0]);
		exit(1);
	}
		

	
	/* init pipes: one for commands ...*/
	pipe(fdin);
	
	/* ... and a pipe for output and stderr, if enabled */

	if (buf_out)
		pipe(fdout);
	if (buf_err)
		pipe(fderr);

	/* fork off a child for exec'ing the program */
	
	if ((kid=fork())==0) {
		/* 
		 * child
		 */
		close(fdin[1]);
		dup2(fdin[0],fileno(stdin));
		if (buf_out) {
			close(fdout[0]);
			close(fileno(stdout));
			if (dup2(fdout[1],fileno(stdout)) != fileno(stdout))
					perror("dup2 stdout");
					
		}
		if (buf_err) {
			close(fderr[0]);
			close(fileno(stderr));
					
			if (dup2(fderr[1],fileno(stderr)) != fileno(stderr))
					perror("dup2 stderr");
		}
		execvp(argv[1+optind-1], &argv[1+optind-1]);
		printf("%s %p\n",argv[1+optind-1], argv[2+optind-1]);
		exit(1);
	}

	if (waitpid(kid,NULL,WNOHANG)) {
		fprintf(stderr,"kid exited unexpectedly\n");
		exit(2);
	}

	/* 
	 * parent
	 */

	if (kid < 0) {
		perror("fork");
		exit(2);
	}

	/* close superfluous fdin */
	close(fdin[0]);
	if (buf_out) {
		close(fdout[1]);
		fcntl(fdout[0],F_SETFL,fcntl(fdout[0],F_GETFL)|O_NONBLOCK);
	}
	if (buf_err) {
		close(fderr[1]);
		fcntl(fderr[0],F_SETFL,fcntl(fderr[0],F_GETFL)|O_NONBLOCK);
	}


	if (!prompt) {
		prompt=malloc(strlen(argv[1+optind-1])+strlen(PROMPTSUFFIX)+1);
		strcpy(prompt,argv[1+optind-1]);
		strcpy(prompt+strlen(argv[1+optind-1]),PROMPTSUFFIX);
	}
 
	do {
		if (buf_out) {
			usleep(usleep_value);
			while ((bytes_read=read(fdout[0],&buf,sizeof(buf))) > 0 || errno == EAGAIN) {
				if (bytes_read < 0) {
					usleep(usleep_value);
					bytes_read=read(fdout[0],&buf,sizeof(buf));
				}
				if (debug) fprintf(stdout,"(read %i on fdout)\n",bytes_read);
				if (bytes_read > 0)
					write(fileno(stdout),buf,bytes_read);
				else
					break;

				usleep(usleep_value);
			}
			if (bytes_read == 0 || (bytes_read < 0 && errno != EAGAIN))
				break;
		}
		if (buf_err) {
			usleep(usleep_value);
			while ((bytes_read=read(fderr[0],&buf,sizeof(buf))) > 0 || errno == EAGAIN) {
				if (bytes_read < 0) {
					usleep(usleep_value);
					bytes_read=read(fderr[0],&buf,sizeof(buf));
				}
				if (debug) fprintf(stderr,"(read %i on fderr)\n",bytes_read);
				if (bytes_read > 0)
					write(fileno(stderr),buf,bytes_read);
				else
					break;

				usleep(usleep_value);
			}
			if (bytes_read == 0 || (bytes_read < 0 && errno != EAGAIN))
				break;
		}

		if (kill(kid,0) < 0)
			break;
		currentline = (uint8_t *) NULL;
    if (currentline == NULL) {
      currentline = readline(prompt); /* produces its own prompt character */
      currentpointer = currentline;
/*
 * don't store empty lines or ones that are the same as the previous one 
 * there is still a bug in this that makes it add the same history line
 * if the entry was obtained by scrolling, but readline bugged me enough
 * for today. At least it doesn't dump core anymore!
 * - aoe
 */
      if (currentline != NULL && strcmp(currentline,"")) {
        prevh = previous_history();
        if (prevh != NULL) {  /* history not empty */
          if (prevh->line != NULL) {  
/*            printf("history: %s\n",prevh->line); */
            if (strcmp(currentline,prevh->line)) {
              add_history(currentline);
            }
          }
        } else {              /* history _is_ empty */
            add_history(currentline);
        }
      }
    } 
 
		/* if (currentline == NULL && currentpointer[0] == 0) {} */
		if (currentpointer == 0) {
			break;
		}
		if (currentline && currentpointer) {
			if (write (fdin[1],currentline,strlen(currentline)) < 0)
				break;
			if (write (fdin[1],"\n",1) < 0)
				break;
		}
     /* printf ("%s\n", currentline); */

		if (kill(kid,0) < 0)
			break;

	} while (1); /* while (currentline != NULL); */
	if (buf_out) {
		usleep(usleep_value);
		while ((bytes_read=read(fdout[0],&buf,sizeof(buf))) > 0 || errno == EAGAIN) {
			if (bytes_read < 0) {
				usleep(usleep_value);
				bytes_read=read(fdout[0],&buf,sizeof(buf));
			}
			if (debug) fprintf(stdout,"(read %i on fdout)\n",bytes_read);
			if (bytes_read > 0)
				write(fileno(stdout),buf,bytes_read);
			else
				break;

			usleep(usleep_value);
		}
	}
	if (buf_err) {
		usleep(usleep_value);
		while ((bytes_read=read(fderr[0],&buf,sizeof(buf))) > 0 || errno == EAGAIN) {
			if (bytes_read < 0) {
				usleep(usleep_value);
				bytes_read=read(fderr[0],&buf,sizeof(buf));
			}
			if (debug) fprintf(stderr,"(read %i on fderr)\n",bytes_read);
			if (bytes_read > 0)
				write(fileno(stderr),buf,bytes_read);
			else
				break;

			usleep(usleep_value);
		}
	}

	close (fdin[1]);

	if (buf_out) 
		close (fdout[0]);
	if (buf_err)
		close (fderr[0]);
	kill(kid,SIGTERM);
	usleep(usleep_value);
	kill(kid,SIGKILL);
	wait(NULL);
	/* lf after empty prompt */
	printf("\n");
	exit(0);
} 
