#include <assert.h>

typedef long Int;

Int binsearch(const Int a[], Int size, Int key)
{
  Int low,high,i;
  
  assert(size>=0);
  for (i=0; i<size-1; i++)
    assert(a[i]<a[i+1]);

  for (low=0, high=size; low < high; ) {
    i = (low+high)/2;
    if (a[i]==key)
      return i;
    if (a[i]>key)
      high=i;
    else
      low=i+1;
  }
  return -1;
}

#ifdef TEST
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
  Int a[argc-1]; /* mit gcc uebersetzen */
  Int i, key, size, x;

  if (argc<2) {
    fprintf(stderr,"usage: %s num ...\n", argv[0]);
    exit(1);
  }
  key=atoi(argv[1]);
  for (i=2; i<argc; i++)
    a[i-2]=atoi(argv[i]);
  size=argc-2;
/*  for (i=0; i<argc-1; i++)
    printf("a[%d]=%d\n",i,a[i]);
*/
  i=binsearch(a,size,key);
  printf("binsearch(a,%ld,%ld)=a[%ld]=%ld\n",
	 size,
	 key,
	 i,
	 i<0L ? 999999999L : a[i]);
  return 0;
}
#endif
