#include <assert.h>

typedef long Int;

Int linsearch(const Int a[], Int size, Int key)
{
  Int i;
  
  assert(size>=0);
  for (i=0; i<size; i++)
    if (a[i]==key)
      return i;
  return -1;
}

#ifdef TEST
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
  Int a[argc-1]; /* mit gcc uebersetzen */
  Int i, key;

  if (argc<2) {
    fprintf(stderr,"usage: %s num ...\n", argv[0]);
    exit(1);
  }
  key=atoi(argv[1]);
  for (i=2; i<argc; i++)
    a[i-2]=atoi(argv[i]);
/*  for (i=0; i<argc-1; i++)
    printf("a[%d]=%d\n",i,a[i]);
*/
  i=linsearch(a,argc-2,key);
  printf("linsearch(a,%ld,%ld)=a[%ld]=%ld\n",
	 argc-2,
	 key,
	 i,
	 i<0L ? 999999999L : a[i]);
  return 0;
}
#endif
