-- test cases for Aufgabe10.hs ($Id: check_Aufgabe10.hs,v 1.5 2004/01/16 21:34:59 fp010 Exp $)
----------------------------------------------------------------------------
-- instance Eq Token
Mult == Mult
Mult /= Add
Add == Add
Fak == Fak
Pot == Pot
[Invalid,Add,Fak,Pot,Mult,Value 0] == [Invalid,Add,Fak,Pot,Mult,Value 0]
Invalid == Invalid
Invalid /= Pot && Pot /= Invalid
Invalid /= Add && Add /= Invalid
Invalid /= Fak && Fak /= Invalid
Invalid /= Mult && Mult /= Invalid
Invalid /= (Value 0) && (Value 0) /= Invalid
Value (-1) /= Value 1 && Value 1 /= Value (-1)
Value (-1) == Value (-1)
-- inOut :: (String->String)->IO Integer
-- tokenize :: String -> [Token]
tokenize "" == []
tokenize " " == []
tokenize "          " == []
all (\n -> tokenize (show n) == [Value n]) [-100..100]
tokenize "0" == [Value 0]
tokenize "000" == [Value 0]
tokenize "0001" == [Value 1]
tokenize "0x42" == [Value 0,Invalid,Value 42]
tokenize "1 2 +" == [Value 1, Value 2, Add]
tokenize "1 2 -" == [Value 1, Value 2, Invalid]
tokenize "-1-" == [Value (-1), Invalid]
tokenize "-" == [Invalid]
tokenize "- " == [Invalid]
tokenize " - 1 " == [Invalid,Value 1]
tokenize "--1" == [Invalid,Value (-1)]
tokenize "**++^^!!" == [Mult,Mult,Add,Add,Pot,Pot,Fak,Fak]
tokenize "(-1)!!" == [Invalid,Value (-1),Invalid,Fak,Fak]
tokenize "* 3 4 5 ^" == [Mult, Value 3, Value 4, Value 5, Pot]
tokenize "123 4 *" == [Value 123, Value 4, Mult]
tokenize "%345-$12" == [Invalid, Value 345, Invalid, Invalid, Value 12]
-- null $ tokenize "\t\n\v\f\r \160" -- isSpace
length (tokenize [c|c <- [minBound..'\255'], c `notElem` "\t\n\v\f\r\160"]) == 240
-- filter :: [Token]->[Token]
filter [Add, Mult, Fak, Pot] == [Add, Mult, Fak, Pot]
filter [Add, Invalid, Invalid, Pot] == [Add, Pot]
filter [Invalid, Add, Add] == [Add, Add]
filter [Add, Add, Invalid] == [Add, Add]
filter (tokenize [minBound..'\255']) == [Fak,Mult,Add,Value 123456789,Pot]
-- toString :: [Integer] -> String
toString [] == "Error"
toString [0] == "0"
toString [1,2,3,4] == "4 3 2 1"
toString [-1,0,1] == "1 0 -1"
tokenize (toString [100,99..(-100)]) == map Value [-100..100]
-- interpret :: [Token] -> [Integer]
-- interpret [Invalid] == undefined
interpret [] == []
interpret [Fak] == []
interpret [Value 3,Fak] == [6]
interpret [Value 3,Add,Fak] == [3]
interpret [Value 3,Mult,Fak] == [3]
interpret [Value 3,Pot,Fak] == [3]
-- interpret ([Value 5,Value 11,Add,Add]++repeat (Value 0)) == [16] -- lazyness
(interpret . tokenize) "32 2^" == [4294967296]
(interpret . tokenize) "32-2^" == [4294967296]
(interpret . tokenize) "-32-2^" == [4294967296]
(interpret . tokenize) "-32-2^" == [4294967296]
(interpret . tokenize) "-32-0^" == [0]
(interpret . tokenize) "-32 0^" == [0]
(interpret . tokenize) "0 2^" == [1]
(interpret . tokenize) "0 0^" == [1]
(interpret . tokenize) "-3!-2!-1!0!1!2!3!" == [6,2,1,1,-1,-1,-1]
(interpret . tokenize) "20      5*" == [100]
(interpret . filter . tokenize) "20      5*-" == [100]
(toString . interpret . filter . tokenize) "20-" == "20"
(toString . interpret . filter . tokenize) "20+" == "20"
(toString . interpret . filter . tokenize) "20+5" == "20"
(toString . interpret . filter . tokenize) "20 5 +   " == "25"
(toString . interpret . filter . tokenize) "20 -21 + 5^" == "5"
(toString . interpret . filter . tokenize) "-5$%!" == "-1"
-- main :: IO ()
----------------------------------------------------------------------------
-- $Log: check_Aufgabe10.hs,v $
-- Revision 1.5  2004/01/16 21:34:59  fp010
-- made some cases more tolerant
--
-- Revision 1.4  2004/01/16 10:21:22  fp010
-- added testcases to test termination in interpret
--
-- Revision 1.3  2004/01/16 08:36:08  fp010
-- fixed typos
--
-- Revision 1.2  2004/01/16 08:31:09  fp010
-- added testcases of my own
--
-- Revision 1.1  2004/01/16 07:23:38  fp010
-- imported testcases by Jeremy Martin Jancsary
--
