-- test cases for Aufgabe7.hs ($Id: check_Aufgabe7.hs,v 1.5 2004/01/06 16:08:46 fp010 Exp $)
----------------------------------------------------------------------------
-- type Graph id = [(id,[id])]
-- insert :: Num id => (id,[id]) -> Graph id -> Graph id
insert (1,[]) [] == [(1,[])]
insert (1,[1]) [] == [(1,[1])]
(insert (2,[]) $ insert (1,[]) []) `elem` [[(1,[]),(2,[])],[(2,[]),(1,[])]]
(insert (1,[]) $ insert (2,[]) []) `elem` [[(1,[]),(2,[])],[(2,[]),(1,[])]]
(insert (2,[1]) $ insert (1,[2]) []) `elem` [[(1,[2]),(2,[1])],[(2,[1]),(1,[2])]]
(insert (1,[2]) $ insert (2,[1]) []) `elem` [[(1,[2]),(2,[1])],[(2,[1]),(1,[2])]]
-- reachable :: (Ord id, Num id) => Graph id -> [id]
reachable 1 [(1,[])] == [1] -- empty path from 1 to 1 exists
reachable 1 [(1,[1])] == [1]
reachable 1 [(1,[]),(2,[1])] == [1]
reachable 1 [(1,[]),(2,[2])] == [1]
reachable 1 [(1,[]),(2,[1,2])] == [1]
reachable 1 [(1,[1]),(2,[1,2])] == [1]
reachable 2 [(1,[1]),(2,[1,2])] == [1,2]
reachable 2 [(1,[1]),(2,[1])] == [1,2]
reachable 2 [(1,[]),(2,[1])] == [1,2]
reachable 2 [(1,[2]),(2,[1])] == [1,2]
reachable 2 [(1,[1]),(2,[2,1])] == [1,2]
reachable 1 [(1,[3,1]),(2,[2,1]),(3,[])] == [1,3]
reachable 1 [(1,[1,3]),(2,[2,1]),(3,[])] == [1,3]
reachable 2 [(1,[1]),(2,[2,1]),(3,[])] == [1,2]
reachable 2 [(1,[3,1]),(2,[2,1]),(3,[])] == [1,2,3]
reachable 1 [(1,[3]),(2,[1]),(3,[2])] == [1,2,3]
reachable 2 [(1,[3]),(2,[1]),(3,[2])] == [1,2,3]
reachable 3 [(1,[3]),(2,[1]),(3,[2])] == [1,2,3]
and [ reachable from [(n,[mod (n+1) size]) | n <- [0..maxid]] == [0..maxid]  | size <- [1..10], let maxid=size-1, from <- [0..maxid] ]
-- isCyclic :: Num id => Graph id -> Bool
not (isCyclic [])
not (isCyclic [(1,[])])
isCyclic [(1,[1])]
not (isCyclic [(1,[2]),(2,[])])
isCyclic [(1,[2]),(2,[2])]
not (isCyclic [(1,[2,3]),(2,[3]),(3,[])])
isCyclic [(1,[2]),(2,[3]),(3,[1])]
-- isConnected :: Num id => Graph id -> Bool
isConnected [] -- logical conclusion
isConnected [(1,[])] -- empty path from 1 to 1 exists
isConnected [(1,[1])]
not (isConnected [(1,[]),(2,[])])
not (isConnected [(1,[2]),(2,[])])
not (isConnected [(1,[2]),(2,[2])])
not (isConnected [(1,[1]),(2,[2])])
isConnected [(1,[2]),(2,[1])]
not (isConnected [(1,[1,2]),(2,[2])])
not (isConnected [(1,[1]),(2,[2,1])])
isConnected [(1,[1,2]),(2,[2,1])]
not (isConnected [(1,[1,2]),(2,[2,1]),(3,[])])
not (isConnected [(1,[1,2]),(2,[2,1]),(3,[3])])
not (isConnected [(1,[1,2]),(2,[2,1]),(3,[1,2])])
isConnected [(1,[1,2]),(2,[2,1,3]),(3,[1])]
isConnected [(1,[2,3]),(2,[1]),(3,[2])]
isConnected [(1,[2]),(2,[3]),(3,[1])]
-- similar :: Num a => Graph a -> Graph a -> Bool
--cancelled from requirements
-- leaves :: Tree a -> [a]
leaves (INode 1 (Leave 0) (INode 3 (Leave 2) (Leave 4))) ==  leaves (INode 3 (INode 1 (Leave 0) (Leave 2)) (Leave 4))
leaves (INode 0 (Leave 4) (Leave 0)) == [4,0] 
leaves (INode 0 (Leave 4) (INode 13 (Leave 3) (INode 15 (Leave 5) (Leave 40)))) == [4,3,5,40]
-- nodesOnLevel
nodesOnLevel 0 (Leave 33) == [33]
nodesOnLevel 1 (INode 1 (Leave 0) (INode 3 (Leave 45) (Leave 4))) == [0,3]
nodesOnLevel 2 (INode 10 (INode 5 (Leave 0) (Leave 3)) (Leave 43)) == [0,3]
-- similar :: Eq a => Tree a -> Tree a -> Bool
not (similar (Leave 0)    (Leave 1))
similar (Leave 0)    (Leave 0)
similar (INode 0 (Leave 1) (Leave 2)) (INode 0 (Leave 3) (Leave 4))
similar (Leave 0)    (INode 0 (Leave 1) (Leave 2))
not (similar (Leave 1)    (INode 0 (Leave 1) (Leave 2)))
similar (INode 1 (INode 2 (Leave 3) (Leave 3)) (INode 2 (Leave 3) (Leave 3)))   (INode 0 (INode 1 (Leave 3) (Leave 3)) (INode 1 (Leave 3) (Leave 3)))
not (similar (INode 1 (INode 2 (Leave 3) (Leave 3)) (INode 2 (Leave 3) (Leave 3)))   (INode 0 (INode 1 (Leave 3) (Leave 3)) (INode 1 (Leave 3) (Leave 4))))
similar (INode 1 (INode 2 (Leave 3) (Leave 3)) (INode 2 (Leave 3) (Leave 3)))   (INode 0 (INode 2 (Leave 3) (Leave 3)) (INode 2 (Leave 3) (Leave 4)))
not (similar (INode 1 (INode 2 (Leave 3) (Leave 3)) (INode 2 (Leave 3) (Leave 3)))   (INode 0 (INode 1 (Leave 3) (Leave 3)) (INode 2 (Leave 3) (Leave 4))))
-- EOT
----------------------------------------------------------------------------
-- $Log: check_Aufgabe7.hs,v $
-- Revision 1.5  2004/01/06 16:08:46  fp010
-- added some more tests for reachable
--
-- Revision 1.4  2003/12/16 20:36:08  fp010
-- added 2 extreme testcases for isConnected/isCyclic
--
-- Revision 1.3  2003/12/16 11:07:40  fp010
-- added some testcases according to ammended specification
--
-- Revision 1.2  2003/12/15 06:23:45  fp010
-- rely on definition "each node is either a leaf or an internal node" from http://www.nist.gov/dads/HTML/tree.html; thus include leaves in nodesOnLevel/similar
--
-- Revision 1.1  2003/12/14 12:16:58  fp010
-- added a few tests for the tree-related functions based on "Ijon Tichy"s
--
